#include "GetObjects.js"
#include "GetDistance.js"

function DoInset()
{
	var objectpicker = moi.ui.createObjectPicker();
	objectpicker.allowFaces();
	
	if ( !GetObjects( objectpicker ) )
		return;
		
	var objects = objectpicker.objects;

	var factory = moi.command.createFactory( 'inset' );
	factory.setInput( 0, objects );

	factory.disableUpdate( true );
	moi.ui.bindUIToInput( 'direction', 'value', factory.getInput(2) );
	moi.ui.bindUIToInput( 'expand', 'value', factory.getInput(3) );
	moi.ui.bindUIToInput( 'useseparateheight', 'value', factory.getInput(4) );
	moi.ui.bindUIToInput( 'height', 'value', factory.getInput(5) );
	moi.ui.bindUIToInput( 'grooved', 'value', factory.getInput(6) );
	moi.ui.bindUIToInput( 'groovewidth', 'value', factory.getInput(7) );
	factory.disableUpdate( false );
	
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectPrompt' );
	moi.ui.showUI( 'InsetOptionsPrompt' );
	moi.ui.showUI( 'InsetOptions' );
	moi.ui.endUIUpdate();
	
	if ( !GetDistance( factory, 1, 'thickness', {allowzero:true} ) )
		return;
	
	factory.commit();
}

DoInset();
